<?php
  class KDetfiles {
    var $DIR_PERMISSIONS  = 0755;
    var $FILE_PERMISSIONS = 0644;
    var $picType=array();
    var $clipType=array();
    var $digits=array();
    var $digitHexa=array();
    var $mimeExt=array();
    function KDetfiles(){
      $this->digits=array('0','1','2','3','4','5','6','7','8','9');
      $this->digitHexa=array('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
      $this->picType['image/gif']['mimid']= 33;
      $this->picType['image/gif']['phpid']= IMG_GIF;
      $this->picType['image/gif']['cap']= 'GIF Image';
      $this->picType['image/jpeg']['mimid']= 2;
      $this->picType['image/jpeg']['phpid']= IMG_JPG;
      $this->picType['image/jpeg']['cap']= 'JPEG Image';
      $this->picType['image/pjpeg']['mimid']= 2;
      $this->picType['image/pjpeg']['phpid']= IMG_JPG;
      $this->picType['image/pjpeg']['cap']= 'JPEG Image';
      $this->picType['image/png']['mimid']= 3;
      $this->picType['image/png']['phpid']= IMG_PNG;
      $this->picType['image/png']['cap']= 'PNG Image';
      $this->picType['image/xpm']['mimid']= 205;
      $this->picType['image/xpm']['phpid']= IMG_WBMP;
      $this->picType['image/xpm']['cap']= 'X PixMap';
      $this->picType['image/vnd.wap.wbmp']['mimid']= 204;
      $this->picType['image/vnd.wap.wbmp']['phpid']= IMG_XPM;
      $this->picType['image/vnd.wap.wbmp']['cap']= 'Image WBMP (Wireless BMP)';

      $this->clipType['application/x-shockwave-flash']['mimid']= 4;
      $this->clipType['application/x-shockwave-flash']['ext']= 'swf';
      $this->clipType['application/x-shockwave-flash']['cap']= 'Macromedia Flash movies';
      $this->clipType['application/x-shockwave-flash']['mimid']= 104;
      $this->clipType['application/x-shockwave-flash']['ext']= 'flv';
      $this->clipType['application/x-shockwave-flash']['cap']= 'Macromedia Flash movies';
      $this->mediaType['video/x-ms-asf']['mimid']=105;
      $this->mediaType['video/x-ms-asf']['asf']= 'flv';
      $this->mediaType['video/x-ms-asf']['cap']= 'Macromedia Flash movies';
      $this->mediaType['video/x-msvideo']['mimid']= 94;
      $this->mediaType['video/x-msvideo']['ext']= 'avi';
      $this->mediaType['video/x-msvideo']['cap']= 'Video For Windows (AVI)';
      $this->mimeExt['jpg']['mimid']=2;
      $this->mimeExt['jpg']['type']='image/jpeg';
      $this->mimeExt['jpg']['embed']='pic';
      $this->mimeExt['jpg']['cap']= 'JPEG image';
      $this->mimeExt['jpeg']['mimid']=2;
      $this->mimeExt['jpeg']['type']='image/jpeg';
      $this->mimeExt['jpeg']['embed']='pic';
      $this->mimeExt['jpeg']['cap']= 'JPEG image';
      $this->mimeExt['jpe']['mimid']=2;
      $this->mimeExt['jpe']['type']='image/jpeg';
      $this->mimeExt['jpe']['embed']='pic';
      $this->mimeExt['jpe']['cap']= 'JPEG image';
      $this->mimeExt['png']['mimid']=3;
      $this->mimeExt['png']['type']='image/png';
      $this->mimeExt['png']['embed']='pic';
      $this->mimeExt['png']['cap']= 'Portable Network Graphic';
      $this->mimeExt['gif']['mimid']=33;
      $this->mimeExt['gif']['type']='image/gif';
      $this->mimeExt['gif']['embed']='pic';
      $this->mimeExt['gif']['cap']= 'GIF image';
      $this->mimeExt['wbmp']['mimid']=204;
      $this->mimeExt['wbmp']['type']='image/vnd.wap.wbmp';
      $this->mimeExt['wbmp']['embed']='pic';
      $this->mimeExt['wbmp']['cap']= 'Image WBMP (Wireless BMP)';
      $this->mimeExt['xpm']['mimid']=205;
      $this->mimeExt['xpm']['type']='image/xpm';
      $this->mimeExt['xpm']['embed']='pic';
      $this->mimeExt['xpm']['cap']= 'X PixMap';

      $this->mimeExt['swf']['mimid']=4;
      $this->mimeExt['swf']['type']='application/x-shockwave-flash';
      $this->mimeExt['swf']['embed']='shck';
      $this->mimeExt['swf']['cap']= 'Macromedia Flash movies';
      $this->mimeExt['flv']['mimid']=104;
      $this->mimeExt['flv']['type']='application/x-shockwave-flash';
      $this->mimeExt['flv']['embed']='shck';
      $this->mimeExt['flv']['cap']= 'Macromedia Flash movies';
      $this->mimeExt['flv']['is_video']='flv';
      $this->mimeExt['asf']['mimid']=105;
      $this->mimeExt['asf']['type']='video/x-ms-asf';
      $this->mimeExt['asf']['embed']='mvp';
      $this->mimeExt['asf']['cap']= 'Microsoft video';
      $this->mimeExt['asx']['mimid']=106;
      $this->mimeExt['asx']['type']='video/x-ms-asf';
      $this->mimeExt['asx']['embed']='mvp';
      $this->mimeExt['asx']['cap']= 'Microsoft video';
      $this->mimeExt['wmv']['mimid']=107;
      $this->mimeExt['wmv']['type']='video/x-ms-wmv';
      $this->mimeExt['wmv']['embed']='mvp';
      $this->mimeExt['wmv']['cap']= 'Microsoft video';
      $this->mimeExt['wvx']['mimid']=108;
      $this->mimeExt['wvx']['type']='video/x-ms-wvx';
      $this->mimeExt['wvx']['embed']='mvp';
      $this->mimeExt['wvx']['cap']= 'Microsoft video';
      $this->mimeExt['wm']['mimid']=109;
      $this->mimeExt['wm']['type']='video/x-ms-wm';
      $this->mimeExt['wm']['embed']='mvp';
      $this->mimeExt['wm']['cap']= 'Microsoft video';
      $this->mimeExt['wmx']['mimid']=110;
      $this->mimeExt['wmx']['type']='video/x-ms-wmx';
      $this->mimeExt['wmx']['embed']='mvp';
      $this->mimeExt['wmx']['cap']= 'Microsoft video';
      $this->mimeExt['wma']['mimid']=111;
      $this->mimeExt['wma']['type']='audio/x-ms-wma';
      $this->mimeExt['wma']['embed']='mvp';
      $this->mimeExt['wma']['cap']= 'Microsoft video';
      $this->mimeExt['wax']['mimid']=112;
      $this->mimeExt['wax']['type']='audio/x-ms-wax';
      $this->mimeExt['wax']['embed']='mvp';
      $this->mimeExt['wax']['cap']= 'Microsoft video';
      $this->mimeExt['wmz']['mimid']=113;
      $this->mimeExt['wmz']['type']='application/x-ms-wmz';
      $this->mimeExt['wmz']['embed']='mvp';
      $this->mimeExt['wmz']['cap']= 'Microsoft application';
      $this->mimeExt['wmd']['mimid']=114;
      $this->mimeExt['wmd']['type']='application/x-ms-wmd';
      $this->mimeExt['wmd']['embed']='mvp';
      $this->mimeExt['wmd']['cap']= 'Microsoft application';
      $this->mimeExt['avi']['mimid']=115;
      $this->mimeExt['avi']['type']='video/x-msvideo';
      $this->mimeExt['avi']['embed']='mvp';
      $this->mimeExt['avi']['cap']= 'Microsoft video';
      $this->mimeExt['mov']['mimid']=116;
      $this->mimeExt['mov']['type']='video/quicktime';
      $this->mimeExt['mov']['embed']='qtv';
      $this->mimeExt['mov']['cap']= 'QuickTime video';
      $this->mimeExt['qt']['mimid']=116;
      $this->mimeExt['qt']['type']='video/quicktime';
      $this->mimeExt['qt']['embed']='qtv';
      $this->mimeExt['qt']['cap']= 'QuickTime video';
      $this->mimeExt['mpe']['mimid']=117;
      $this->mimeExt['mpe']['type']='video/mpeg';
      $this->mimeExt['mpe']['embed']='qtv';
      $this->mimeExt['mpe']['cap']= 'MPEG video';
      $this->mimeExt['mpeg']['mimid']=117;
      $this->mimeExt['mpeg']['type']='video/mpeg';
      $this->mimeExt['mpeg']['embed']='qtv';
      $this->mimeExt['mpeg']['cap']= 'MPEG video';
      $this->mimeExt['mpg']['mimid']=117;
      $this->mimeExt['mpg']['type']='video/mpeg';
      $this->mimeExt['mpg']['embed']='qtv';
      $this->mimeExt['mpg']['cap']= 'MPEG video';
      $this->mimeExt['mp3']['mimid']=120;
      $this->mimeExt['mp3']['type']='audio/x-mpeg';
      $this->mimeExt['mp3']['embed']='qtv';
      $this->mimeExt['mp3']['cap']= 'MPEG audio';
    }

    function mimeType(){
      $mimeType=array();
      foreach($this->mimeExt as $ext=>$inf) {
        if(isset($mimeType[$inf['type']])){
          unset($exts);
          $exts=$mimeType[$inf['type']]['ext'];
          $exts[]=$ext;
          unset($mimeType[$inf['type']]['ext']);
          $mimeType[$inf['type']]['ext']=$exts;
        }else{
          unset($exts);
          $exts=array($ext);
          $mimeType[$inf['type']]['embed']=$inf['embed'];
          $mimeType[$inf['type']]['cap']=$inf['cap'];
          $mimeType[$inf['type']]['ext']=$exts;
        }
      }
      return $mimeType;
    }

    function ArrSafe($crrArray){
      $aSafeArr=array();
      $aSafeSub=array();
      $strSafe='';
      $strSafeKey='';
      if(is_array($crrArray)){
        foreach($crrArray as $key=>$aVal){
          unset($aSafeSub);
          $strSafeKey=base64_encode($key);
          $aSafeSub=$this->ArrSafe($aVal);
          $aSafeArr[$strSafeKey]=$aSafeSub;
        }
        return $aSafeArr;
      }else{
        $strSafe= base64_encode($crrArray);
        return $strSafe;
      }
    }
    function ArrUnSafe($crrArray){
      $aOrgArr=array();
      $aOrgSub=array();
      $strOrg='';
      $strOrgKey='';
      if(is_array($crrArray)){
        foreach($crrArray as $key=>$aVal){
          unset($aOrgSub);
          $strOrgKey=base64_decode($key);
          $aOrgSub=$this->ArrUnSafe($aVal);
          $aOrgArr[$strOrgKey]=$aOrgSub;
        }
        return $aOrgArr;
      }else{
        $strOrg= base64_decode($crrArray);
        return $strOrg;
      }
    }
    function SerSafe($crrArray){
      $strSafe=array();
      $aSafeArr=array();
      if(is_array($crrArray)){
        $aSafeArr= $this->ArrSafe($crrArray);
        $crrStr = serialize($aSafeArr);
        $strSafe= base64_encode($crrStr);
      }else{
        $crrStr= trim($crrArray);
        if(strlen($crrStr)>0){
          $strSafe = $this->ArrSafe($crrStr);
        }
      }
      return $strSafe;
    }
    function doFlashSafe($encoded64){
      $FlashSafe='';
      $FlashSafe=str_replace("+", '!', $encoded64);
      $FlashSafe=str_replace("=", '_', $FlashSafe);
      $FlashSafe=str_replace("/", '$', $FlashSafe);
      return $FlashSafe;
    }
    function unFlashSafe($FlashSafe){
      $encoded64='';
      $encoded64=str_replace('!', "+", $FlashSafe);
      $encoded64=str_replace('_', "=", $FlashSafe);
      $encoded64=str_replace('$', "/", $FlashSafe);
      return $encoded64;
    }
    function UnSerSafe($crrStr){
      $aOrgArr=array();
      $strOrgStr='';
      $strTmp= trim($crrStr);
      if(strlen($strTmp)>0){
        $strOrgStr= base64_decode($strTmp);
        $pos = strpos($strOrgStr, 'a:');
        if($pos===0){
          $aTmp= unserialize($strOrgStr);
          $aOrgArr=$this->ArrUnSafe($aTmp);
          return $aOrgArr;
        }
      }
      return $strOrgStr;
    }
    function ReplaceTags($strcrrShab,$acrrRplcVals){
      $strHex = $this->strToHex($strcrrShab);
      if(is_array($acrrRplcVals)and count($acrrRplcVals)>0){
        foreach ($acrrRplcVals as $tagname => $tagval){
          $tag = '%' . $tagname .'%';
          $tagHex=$this->strToHex($tag);
          $tagvalHex=$this->strToHex($tagval);
          $strHex = str_replace($tagHex, $tagvalHex, $strHex);
        }
      }
      $strHtm=$this->hexToStr($strHex);
      return $strHtm;
    }
    function strToHex($string){//return bin2hex($string);
      $hex='';
      for ($i=0; $i < strlen($string); $i++){
        if (ord($string[$i])<16){$hex .= '0';}
        $hex .= dechex(ord($string[$i]));
      }
      return strtoupper($hex);
    }
    function hexToStr($hex){
      $string='';
      for ($i=0; $i < strlen($hex)-1; $i+=2){
        $string .= chr(hexdec($hex[$i].$hex[$i+1]));
      }
      return $string;
    }

    function UploadFile($strcrrFileFld,$strcrrFullPass,$strcrrFileName){
      $strPicName='';
      $iErr=0;
      clearstatcache();
      if (isset($_FILES[$strcrrFileFld])
      and trim($_FILES[$strcrrFileFld]["name"]) !=''
      and $_FILES[$strcrrFileFld]["size"]>0
      and $_FILES[$strcrrFileFld]["error"]==0
      and (trim($strcrrFileName) !='')){
        $aNamParts=explode('.', $_FILES[$strcrrFileFld]["name"]);
        $iPqty=count($aNamParts);
        if($iPqty>1 and trim($aNamParts[$iPqty-1]) !=''){
          $strName = KDetfiles::nameToSafe($strcrrFileName . '.' . $aNamParts[$iPqty-1]);
          $strFullName = $strcrrFullPass . '/' . $strName;
          if(is_file($strFullName)){
            if(!unlink($strFullName)){$iErr=1;}
          }
          if($iErr==0){
            if (!move_uploaded_file($_FILES[$strcrrFileFld]["tmp_name"],$strFullName)){
              $iErr=1;
            }
          }
          if($iErr==0){ $strPicName=$strName; }
        }
      }
      return $strPicName;
    }
    function readDirectory($path, $directoriesOnly=FALSE, $filesOnly=FALSE, $recursive=FALSE, $extensions=array(), $appendPath=FALSE){
      $subs=array();
      if($directoriesOnly and $filesOnly) {
        $directoriesOnly = FALSE;
        $filesOnly = FALSE;
      }
      clearstatcache();
      if (!is_dir($path)){ return FALSE;}
      $dir = dir($path);
      while ($file = $dir->read()){
        $fullpath = $path . "/" . $file;
        if ($directoriesOnly  and !$filesOnly
        and is_dir($fullpath)
        and $file != "." and $file != ".." and $file != "CVS") {
          if($appendPath){$directory[] = $fullpath;}else {$directory[] = $file;}
        }elseif(!$directoriesOnly and $filesOnly
        and !is_dir($fullpath)
        and $file != "." and $file != ".." and $file != "CVS") {
          if(is_array($extensions) and count($extensions) > 0) {
            $extTest = explode(".", $file);
            if(isset($extTest[1]) and in_array($extTest[1], $extensions)) {
              if($appendPath){$directory[] = $fullpath;}else{$directory[] = $file;}
            }
          }elseif($appendPath){ $directory[] = $fullpath;
          }else{$directory[] = $file;}
        }elseif(!$directoriesOnly and !$filesOnly
        and $file != "." and $file != ".." and $file != "CVS") {
          if(!is_dir($path . $file) and is_array($extensions) and count($extensions) > 0) {
            $extTest = explode(".", $file);
            if(in_array($extTest[1], $extensions)) {
              if($appendPath){$directory[] = $fullpath;} else{$directory[] = $file;}
            } elseif($appendPath){ $directory[] = $fullpath;}  else{  $directory[] = $file;}
          } else {
            if($appendPath){$directory[] = $fullpath;} else{$directory[] = $file;}
          }
        }
        if($recursive and is_dir($fullpath) and !is_link($fullpath) and ($file != ".") and ($file != "..") and ($file != "CVS")){
          unset($subs);
          $subs=KDetfiles::readDirectory($fullpath . "/", $directoriesOnly, $filesOnly, $recursive, $extensions, $appendPath);
          if(is_array($subs)){$directory = array_merge($directory, $subs);}
        }
      }
      $dir->close();
      if (isset($directory)){return $directory;} else{ return NULL;}
    }
    function getFileInfoEx($pathFull){
      $ainfo=array();
      $pinfo=array();
      $size=array();
      $attrs=array();
      $info=array();
      $id=0;
      $tdz='';
      $pinfo=pathinfo($pathFull);
      $ainfo['flnameshrt']=$pinfo['basename'];
      $ainfo['ext']='';
      if(isset($pinfo['extension'])){$ainfo['ext']=$pinfo['extension'];}
      $ainfo['time_acs']=date("Y-m-d H:i:s",fileatime($pathFull));
      $ainfo['time_chg']=date("Y-m-d H:i:s",filectime($pathFull));
      $tdz=date("O",filemtime($pathFull));
      $ainfo['time_mod']=str_replace('@','T',date("Y-m-d@H:i:s",filemtime($pathFull))) . substr($tdz,0,3) . ':' . substr($tdz,3,2);
      $ainfo['filesize']=filesize($pathFull);
      $ainfo['mimeExt']=array();
      if(isset($this->mimeExt[$ainfo['ext']])){
        $ainfo['mimeExt']=$this->mimeExt[$ainfo['ext']];
      }
      $ainfo['name']=str_replace('.'.$ainfo['ext'],'',$ainfo['flnameshrt']);
      $ainfo['sfx']=substr($ainfo['name'], 0,1);
      $id_try=trim(substr($ainfo['name'], 1));
      $id_not=str_replace($this->digits, '', $id_try);
      if($id_not==''){
        $id_try=0+$id_try;
        if($id_try>0){$id=$id_try;}
      }
      $ainfo['id']=$id;
      unset($info);
      $size = getimagesize($pathFull, $info);
      $ainfo['getimage']=$size;
      if(isset($info)){
        if(is_array($info)){
          foreach($info as $atrname=>$attrval){
            $attrs[$atrname]=iptcparse($attrval);
          }
        }else{
          $attrs['scal']=$info;
        }
      }
      $ainfo['attrs']=$attrs;
      return $ainfo;
    }
    function getZip_File($zip_file_full,$file_name,$dirTo){
      $aResult=array();
      $aResult['body']='';
      $aResult['ffile']='';
      $aResult['lstErrs']=array();
      $body='';
      if(!is_dir($dirTo)){
        $aResult['lstErrs'][1]='"' .$dirTo . '" Is not directory';
	      return $aResult;
      }
      $aResult['ffile']=str_replace('//','/' ,$dirTo . '/' . $file_name);
      if(is_file($dirTo)){
        $aResult['lstErrs'][1]='"' .$dirTo . '" Is not directory';
        return $aResult;
      }
      if(is_file($aResult['ffile'])){
        $aResult['lstErrs'][1]='File "' .$file_name . '" already exists';
        return $aResult;
      }
      $zip_cat=new ZipArchive();
      $open=$zip_cat->open($zip_file_full);
      if($open=== false){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" Is not zip';
        return $aResult;
      }
      $filendex=$zip_cat->locateName($file_name);
      if($filendex === false){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" does not contain "' . $file_name . '"';
        $zip_cat->close();
        clearstatcache();
        return $aResult;
      }
      $zerr=$zip_cat->extractTo($dirTo,$file_name);
      if($zerr===false){
        $aResult['lstErrs'][1]='unable to read file "' . $file_name . '"';
        $zip_cat->close();
        clearstatcache();
        return $aResult;
      }
      $zip_cat->close();
      clearstatcache();
      if(!is_file($aResult['ffile'])){
        $aResult['lstErrs'][1]='File "' .$aResult['ffile'] . '" does not exist';
        return $aResult;
      }

      return $aResult;
    }
    function getZip_Str($zip_file_full,$file_name){
      $aResult=array();
      $aResult['body']=array();
      $aResult['lstErrs']=array();
      $body='';
      if(!is_file($zip_file_full)){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" Is not file';
	      return $aResult;
      }
      $zip_cat=new ZipArchive();
      $open=$zip_cat->open($zip_file_full);
      if($open=== false){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" Is not zip';
        return $aResult;
      }
      $filendex=$zip_cat->locateName($file_name);
      if($filendex === false){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" does not contain "' . $file_name . '"';
        $zip_cat->close();
        clearstatcache();
        return $aResult;
      }
      $body=$zip_cat->getFromName($file_name);
      if($body===false){
        $aResult['lstErrs'][1]='unable to read file "' . $file_name . '"';
        $zip_cat->close();
        clearstatcache();
        return $aResult;
      }
      $aResult['body']=$body;
      $zip_cat->close();
      clearstatcache();
      return $aResult;
    }
    function addStr2Zip($zip_file_full,$file_name,$strBody,$doOver){
      $aResult=array();
      $aResult['lstErrs']=array();
      if(!is_file($zip_file_full)){
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" Is not file';
	      return $aResult;
      }
      $zip_cat=new ZipArchive();
      if($zip_cat->open($zip_file_full) === TRUE){
        $filendex=$zip_cat->locateName($file_name);
        if($filendex !== false){
          if($doOver>0){
            if($zip_cat->deleteIndex($filendex)===false){
              $aResult['lstErrs'][1]='unable to delete file "' . $file_name . '"';
	            $zip_cat->close();
	            clearstatcache();
	            return $aResult;
            }
          }else{
            $aResult['lstErrs'][1]='"' .$zip_file_full . '" already contains "' . $file_name . '"';
	          $zip_cat->close();
	          clearstatcache();
	          return $aResult;
	        }
        }
        if($zip_cat->addFromString($file_name,$strBody)===false){
          $aResult['lstErrs'][1]='unable to add file "' . $file_name . '"';
        }
        $zip_cat->close();
        clearstatcache();
      }else{
        $aResult['lstErrs'][1]='"' .$zip_file_full . '" Is not zip';
        return $aResult;
      }
      return $aResult;
    }
    function getZipsrct($zip_file){
      $Zipsrct=array();
      $Zipsrct['spec']=array();
      $Zipsrct['stat']['numFiles']='';
      $Zipsrct['stat']['filename']='';
      $Zipsrct['stat']['comment']='';
      $Zipsrct['stat']['status']='';
      $Zipsrct['stat']['statusSys']='';
      $Zipsrct['file_ndx']=array();
      $Zipsrct['lstErrs']=array();
      if(is_file($zip_file)){
	      $zip_cat=new ZipArchive();
	      if($zip_cat->open($zip_file) === TRUE){
	        $Zipsrct['stat']['numFiles']=$zip_cat->numFiles;
	        $Zipsrct['stat']['filename']=$zip_cat->filename;
	        $Zipsrct['stat']['comment']=$zip_cat->comment;
	        $Zipsrct['stat']['status']=$zip_cat->status;
	        $Zipsrct['stat']['statusSys']=$zip_cat->statusSys;
	        for ($i=0;$i<$zip_cat->numFiles; $i++) {
	          $filename=$zip_cat->getNameIndex($i);
	          $Zipsrct['file_ndx'][$filename]['stat']=array();
            $Zipsrct['file_ndx'][$filename]['stat']=$zip_cat->statIndex($i);
            $Zipsrct['file_ndx'][$filename]['stat']['comment'] =$zip_cat->getCommentIndex($i);
	        }
	        if(isset($Zipsrct['file_ndx']['spec/spec.ncr'])){
	          $strSpec=$zip_cat->getFromName('spec/spec.ncr');
            if(trim($strSpec) !=''){
	            $Zipsrct['spec']=$this->UnSerSafe($strSpec);
            }
	        }
          $zip_cat->close();
          clearstatcache();
        }else{
          $Zipsrct['lstErrs'][1]='can not zip-open file: "' .$zip_file . '"';
        }
      }else{
        $Zipsrct['lstErrs'][1]='It is not file: "' .$zip_file . '"';
      }
      return $Zipsrct;
    }
    function getDirsrctEx($path, $directoriesOnly=FALSE, $filesOnly=FALSE,$recursive=FALSE, $extensions=array(), $appendPath=FALSE){
      $aFilesEx=array();
      $stsFiles=array();
      $strFileFull=array();
      $ndx=-1;
      $stsFiles=$this->readDirectory($path,$directoriesOnly,$filesOnly,$recursive,$extensions,$appendPath);
      if(count($stsFiles)>0){
        foreach($stsFiles as $filename){
          $strFileFull=$path .'/'.$filename;
          if(!is_file($strFileFull)){continue;}
          $ndx=$ndx+1;
          $aFilesEx[$ndx]=$this->getFileInfoEx($strFileFull);
        }
      }
      return $aFilesEx;
    }
    function getDirsrct($path, $directoriesOnly=FALSE, $filesOnly=FALSE,$recursive=FALSE, $extensions=array(), $appendPath=FALSE){
      $aResult = array();
      $getDirsrct = array();
      if($directoriesOnly and $filesOnly) {
        $directoriesOnly = FALSE;
        $filesOnly = FALSE;
      }
      clearstatcache();
      if (!is_dir($path)){ return $aResult;}
      $aResult['namefull']=$path;
      $aResult['pathinfo']=pathinfo($path);
      $aResult['contnt']=array();
      $aResult['contnt']['dirs']=array();
      $aResult['contnt']['lkdirs']=array();
      $aResult['contnt']['files']=array();
      $aResult['contnt']['lkfiles']=array();
      $aResult['dirsize']=0;
      $aResult['dirsizerec']=0;
      $aResult['dirqty']=0;
      $aResult['filqty']=0;
      $aResult['lkdirqty']=0;
      $aResult['lkfilqty']=0;
      $aResult['dirqtyrec']=0;
      $aResult['filqtyrec']=0;
      $aResult['lkdirqtyrec']=0;
      $aResult['lkfilqtyrec']=0;
      if(is_link($path)){
        $aResult['realinfo']=pathinfo(realpath($path));
        return $aResult;
      }
      $dir = dir($path);
      $indx=0;
      while ($file = $dir->read()){
        if($file == "." or $file == "..") {continue;}
        $indx=$indx+1;
        $fullpath = $path . "/" . $file;
        if (is_link($fullpath)) {
          if (is_dir($fullpath)) {
            $aResult['contnt']['lkdirs'][$file]['namefull']=  $fullpath;
            $aResult['contnt']['lkdirs'][$file]['pathinfo']=pathinfo($fullpath);
            $aResult['contnt']['lkdirs'][$file]['realinfo']=pathinfo(realpath($fullpath));
          }elseif(is_file($fullpath)) {
            $aResult['contnt']['lkfiles'][$file]['namefull']=  $fullpath;
            $aResult['contnt']['lkfiles'][$file]['pathinfo']=pathinfo($fullpath);
            $aResult['contnt']['lkfiles'][$file]['realinfo']=pathinfo(realpath($fullpath));
          }
        }else{
          if (is_dir($fullpath)) {
            $aResult['contnt']['dirs'][$file]['namefull']=  $fullpath;
            $aResult['contnt']['dirs'][$file]['pathinfo']=pathinfo($fullpath);
            if($recursive){
              unset($getDirsrct);
              $getDirsrct= $this->getDirsrct($fullpath, $directoriesOnly, $filesOnly,$recursive, $extensions, $appendPath);
              $aResult['contnt']['dirs'][$file]['contnt']= $getDirsrct;
              $aResult['dirsizerec']=$aResult['dirsizerec']+$getDirsrct['dirsizerec'];
              $aResult['dirqtyrec']=$aResult['dirqtyrec']+$getDirsrct['dirqtyrec'];
              $aResult['filqtyrec']=$aResult['filqtyrec']+$getDirsrct['filqtyrec'];
              $aResult['lkdirqtyrec']=$aResult['lkdirqtyrec']+$getDirsrct['lkdirqtyrec'];
              $aResult['lkfilqtyrec']=$aResult['lkfilqtyrec']+$getDirsrct['lkfilqtyrec'];
            }else{
              $aResult['contnt']['dirs'][$file]['contnt']=array();
            }
          }elseif(is_file($fullpath)) {
            if(!$directoriesOnly){
	            $aResult['contnt']['files'][$file]['namefull']=  $fullpath;
	            $aResult['contnt']['files'][$file]['pathinfo']=pathinfo($fullpath);
	            $filesize=filesize($fullpath);
	            $aResult['contnt']['files'][$file]['filesize']=$filesize;
	            $aResult['contnt']['files'][$file]['fileatime']=fileatime($fullpath);
	            $aResult['contnt']['files'][$file]['filemtime']=filemtime($fullpath);
	            $aResult['dirsize']=$aResult['dirsize']+$filesize;
            }
          }
        }
      }
      $aResult['dirqty']=count($aResult['contnt']['dirs']);
      $aResult['filqty']=count($aResult['contnt']['files']);
      $aResult['lkdirqty']=count($aResult['contnt']['lkdirs']);
      $aResult['lkfilqty']=count($aResult['contnt']['lkfiles']);
      $aResult['dirqtyrec']=$aResult['dirqtyrec']+$aResult['dirqty'];
      $aResult['filqtyrec']=$aResult['filqtyrec']+$aResult['filqty'];
      $aResult['lkdirqtyrec']=$aResult['lkdirqtyrec']+$aResult['lkdirqty'];
      $aResult['lkfilqtyrec']=$aResult['lkfilqtyrec']+$aResult['lkfilqty'];
      $aResult['dirsizerec']=$aResult['dirsizerec']+$aResult['dirsize'];
      $dir->close();
      return $aResult;
    }
     function recursArrsrct($arrCrr){
      $Arrsrct='scalar';
      $akeys=array();
      $asubs=array();
      if(is_array($arrCrr)){
        $Arrsrct='empty array';
        if(count($arrCrr)>0){
	        unset($Arrsrct);
	        $Arrsrct=array();
          $akeys=array_keys($arrCrr);
          foreach($akeys as $key){
	          unset($asubs);
            $asubs=$arrCrr[$key];
            $Arrsrct[$key]=$this->recursArrsrct($asubs);
          }
        }
      }
      return $Arrsrct;
    }
    function recursiveFileCopy ($crrfromPath, $crrtoPath) {
      $fromPath=str_replace('//','/',$crrfromPath);
      $toPath=str_replace('//','/',$crrtoPath);
      $start_path =  getcwd();
      clearstatcache();
      if (KDetfiles::makeDir($toPath,0777)){
        if (is_dir($fromPath)) {
          chdir($fromPath);
          $handle = opendir('.');
          while (($file = readdir($handle)) !== FALSE) {
            if (($file != ".") and ($file != "..") and ($file != "CVS")) {
              if (is_link($file)) {
                $readlink=readlink($file);
                $newtoFile=str_replace('//','/',$toPath .'/'. $file);
                $didfine = symlink($readlink,$newtoFile);
              }elseif(is_dir($file)) {
                $newfrmPath=str_replace('//','/',$fromPath .'/'. $file . "/");
                $newtoPath=str_replace('//','/',$toPath .'/'. $file . "/");
                KDetfiles::recursiveFileCopy ($newfrmPath, $newtoPath);
                chdir($fromPath);
              }elseif (is_file($file)) {
                $newfrmFile=str_replace('//','/',$fromPath .'/'. $file);
                $newtoFile=str_replace('//','/',$toPath .'/'. $file);
                copy($newfrmFile, $newtoFile);
                KDetfiles::setFilePermissions($newtoFile,0644);
              }
            }
          }
          closedir($handle);
          chdir($start_path);
          return TRUE;
        } else {
          chdir($start_path);
          return FALSE;
        }
      }
    }// END FUNC recursiveFileCopy()
    function recursRmdir($dir) {
      if (!preg_match("/\/$/", $dir)){$dir .= "/";}
      clearstatcache();
      if(is_dir($dir)) {
        $handle = opendir($dir);
        while($file = readdir($handle)) {
          if($file == "." || $file == "..") {
            continue;
          }elseif(is_link($dir . $file)) {
            unlink($dir . "/" . $file);
	          clearstatcache();
          } elseif(is_dir($dir . $file)) {
            KDetfiles::recursRmdir($dir . $file . "/");
            clearstatcache();
          } elseif(is_file($dir . $file)) {
            unlink($dir . "/" . $file);
            clearstatcache();
          }
        }
        closedir($handle);
        $tempDir = explode("/", $dir);
        array_pop($tempDir);
        $sourceDir = implode("/", $tempDir);
        if (is_writable($sourceDir)){
	        $handle = opendir($sourceDir);
	        while($file = readdir($handle)) {
            if($file == '.' || $file == '..') {
	            continue;
	          }elseif(is_file($sourceDir .'/'. $file)) {
              unlink($sourceDir . "/" . $file);
            }
          }
	        closedir($handle);
          clearstatcache();
          return rmdir($dir);
        } else{
          clearstatcache();
          return FALSE;
        }
      } else {
        clearstatcache();
        return FALSE;
      }
    }
    function writeFile($fileName, $text, $allowOverwrite){
      $strError='';
      clearstatcache();
      if (!$allowOverwrite){
        if (is_writable($fileName)){
          $strError= "<b>ERROR:</b> ".$fileName ." exist. Cannot overwrite.";
          return strError;
        }
      }
      if($fp = fopen ($fileName, "wb")){
        fwrite($fp, $text);
        fclose($fp);
        KDetfiles::setFilePermissions($fileName, $this->FILE_PERMISSIONS);
      } else {
        $strError= "<b>ERROR:</b> unable to open file at " . $fileName;
      }
      return $strError;
    }
    function makeDir($pathname, $permissions=NULL) {
      clearstatcache();
      if(is_dir($pathname)) { return true;}
      $dirCreated = false;
      $oldMask = umask(0);
      if ($permissions != NULL){
        $dirCreated = mkdir($pathname, $permissions);
      }else{
        $dirCreated = mkdir($pathname, 0755);
      }
      umask($oldMask);
      return $dirCreated;
    }
    function MakeReplnk($srcFile,$linkfile,$doover){
      $aResult=array();
      $aResult['lstErrs']=array();
      clearstatcache();
      $didfine = true;
      $strErrMsg='';
      $dodelete=file_exists($linkfile);
      if($dodelete) {
        if($doover<1){
          $strErrMsg .='Error: link already exists ('.$linkfile . ')';
          $didfine = false;
        }else{
          $didfine = unlink($linkfile);
	        clearstatcache();
          if(!$didfine){
            $strErrMsg .='Error unlink: link still exists('.$linkfile . ')';
          }
        }
      }
      if($didfine){
        $didfine = symlink($srcFile,$linkfile);
      }else{
        $strErrMsg .='Error symlink: not created('.$linkfile .'=>'.$srcFile .')';
      }
      clearstatcache();
      if($didfine) {
        $didfine=is_link($linkfile);
      }else{
        $strErrMsg .='Error is_link: no is_link('.$linkfile .')';
      }
      clearstatcache();
      if($didfine) {
        $target = readlink($linkfile);
        if($target !=$srcFile){
          $strErrMsg .='Error readlink: wrong target('.$linkfile .'=>'.$target .'!=' . $srcFile .')';
          $didfine = unlink($linkfile);
          $didfine = false;
	        clearstatcache();
        }
      }
      if($didfine) {
        $real = realpath($linkfile);
        if($real !=$srcFile){
          $strErrMsg .='Error realpath: wrong realpath('.$linkfile .'=>'.$real .'!=' . $srcFile .')';
          $didfine = unlink($linkfile);
          $didfine = false;
          clearstatcache();
        }
      }
      if(!$didfine){
        $aResult['lstErrs']['MakeMbrReplnk']=$strErrMsg;
      }else{
        $aResult['filesize']=filesize ($linkfile);
        $aResult['pathinfo']=pathinfo($linkfile);
        $aResult['realinfo']=pathinfo(realpath($linkfile));
      }
      return $aResult;
    }
    function read_File($filename){
      $content='';
      clearstatcache();
      if(file_exists($filename)){
        if ($fd = fopen($filename, 'rb')) {
          $size = filesize($filename);
          if($size){
            $content =fread($fd, $size);
          }
          fclose($fd);
        }
      }
      return $content;
    }
    function setFilePermissions($filename, $permissions) {
      if ($permissions != NULL){
        return chmod($filename, $permissions);
      }else  {
        return chmod($filename, 0644);
      }
    }
    /* Copies a file from one directory to another
     * Example Usage:
     * $copy = fileCopy("/path/to/original.file", "/path/to/", "destination.file", 1, 1);
     * @param    string  $file_origin           Path to file to be copied
     * @param    string  $destination_directory Directory to copy to
     * @param    string  $file_destination      Name to be given to copied file
     * @param    boolean $overwrite             If TRUE overwrite any file in the destination directory
     * @param    boolean $fatal                 If TRUE echo an error if the file does not exist.
     * @return   boolean TRUE on success, FALSE on failure      */
    function fileCopy($file_origin, $destination_directory, $file_destination, $overwrite, $fatal, $permissions=NULL) {
      clearstatcache();
      if ($fatal) {
        $error_prefix = 'FATAL: File copy of \'' . $file_origin . '\' to \''. $destination_directory . $file_destination . '\' failed.';
        $fp = fopen($file_origin, "rb");
        if (!$fp) {
          echo $error_prefix . ' Originating file cannot be read or does not exist.';
          exit();
        }
        $dir_check = is_writeable($destination_directory);
        if (!$dir_check) {
          echo $error_prefix . ' Destination directory is not writeable or does not exist.';
          exit();
        }
        $dest_file_exists = file_exists($destination_directory . $file_destination);
        if ($dest_file_exists) {
          if ($overwrite) {
            $fp = is_writeable($destination_directory . $file_destination);
            if (!$fp) {
              echo  $error_prefix . ' Destination file is not writeable [OVERWRITE].';
              exit();
            }
            if($copy_file = copy($file_origin, $destination_directory . $file_destination)) {
              KDetfiles::setFilePermissions($destination_directory . $file_destination, $permissions);
              return TRUE;
            } else{
              return FALSE;
            }
          }
        } else {
          if($copy_file = copy($file_origin, $destination_directory . $file_destination)) {
            KDetfiles::setFilePermissions($destination_directory . $file_destination, $permissions);
            return TRUE;
          } else{
            return FALSE;
          }
        }
      } else {
        if($copy_file = copy($file_origin, $destination_directory . $file_destination)) {
          KDetfiles::setFilePermissions( $destination_directory . $file_destination, $permissions);
          return TRUE;
        }else {
          return FALSE;
        }
      }
    }
    function Ext2PicExt($exten){
      $aPicExt=array();
      if(isset($this->mimeExt[$exten])){
        if(isset($this->picType[$this->mimeExt[$exten]['type']])){
          $aPicExt=$this->picType[$this->mimeExt[$exten]['type']];
        }
      }
      return $aPicExt;
    }
    function ResizePic($fileInFull,$extOut,$WidthOut,$HeightOut,$doNotExpand,$doBack,$colorBack_ffffff,$dirOutFull,$fileOutshrt){
      $aResult=array();
      $aResult['InfoOutEx']=array();
      $aResult['lstErrs']=array();
      $FileInfoInEx=array();
      $PicExOut=array();
      $PicExIn=array();
      $supported = false;
      $ScaleFin=1;
      $ScaleTry=1;
      $HeightOutTry=0;
      $WidthOutPic=0;
      $HeightOutPic=0;
      $WidthOutCanv=0;
      $HeightOutCanv=0;
      $lOutPic=0;
      $tOutPic=0;
      $Rbg=255;
      $Gbg=255;
      $Bbg=255;
      $sR='FF';
      $sG='FF';
      $sB='FF';
      $Clrbg='FFFFFF';
      $ClrbgTry='';
      $Clrerr='';
      $fileOutFull=$dirOutFull.'/'.$fileOutshrt;
      if($doBack){
        $ClrbgTry=strtoupper(trim($colorBack_ffffff));
        $Clrerr=str_replace($this->digitHexa,'',$ClrbgTry);
        if((strlen($ClrbgTry)==6)and($Clrerr=='')){
          $sR=substr($ClrbgTry,0,2);
          $sG=substr($Clrerr,2,2);
          $sB=substr($Clrerr,4,2);
          $Rbg=(int)base_convert($sR, 16, 10);
          $Gbg=(int)base_convert($sG, 16, 10);
          $Bbg=(int)base_convert($sB, 16, 10);
        }
      }
      $FileInfoInEx=$this->getFileInfoEx($fileInFull);
      if(isset($FileInfoInEx['getimage']['mime'])and isset($this->picType[$FileInfoInEx['getimage']['mime']])){
        $PicExIn=$this->picType[$FileInfoInEx['getimage']['mime']];
        if(!(imagetypes() & $PicExIn['phpid'])){
          $aResult['lstErrs'][1]='Input format error - not supported';
          return $aResult;
        }
      }
      $WidthIn =$FileInfoInEx['getimage'][0];
      $HeightIn=$FileInfoInEx['getimage'][1];
      if(($WidthIn<1) or ($HeightIn<1)){
        $aResult['lstErrs'][1]='Input image Zero size error - not supported';
        return $aResult;
      }
      $PicExOut=$this->Ext2PicExt($extOut);
      if(!(imagetypes() & $PicExOut['phpid'])){
        $aResult['lstErrs'][1]='Output format error - not supported';
        return $aResult;
      }
      clearstatcache();
      $ScaleTry=$WidthOut/$WidthIn;
      $HeightOutTry=$HeightIn * $ScaleTry;
      $portret=false;
      if($HeightOutTry>$HeightOut){
        $ScaleTry=$HeightOut/$HeightIn;
        $portret=true;
      }
      if($doNotExpand and ($ScaleTry>1)){$ScaleTry=1;}
      $ScaleFin=$ScaleTry;
      $WidthOutPic=round($ScaleFin * $WidthIn);
      $HeightOutPic=round($ScaleFin * $HeightIn);
      if($WidthOutPic<1){$WidthOutPic=1;}
      if($HeightOutPic<1){$HeightOutPic=1;}
      $WidthOutCanv=$WidthOutPic;
      $HeightOutCanv=$HeightOutPic;
      if($doBack){
        $lOutPic= round(($WidthOut-$WidthOutPic)/2);
        $tOutPic= round(($HeightOut-$HeightOutPic)/2);
        $WidthOutCanv=$WidthOut;
        $HeightOutCanv=$HeightOut;
      }
      $chkgd2= KDetfiles::chkgd2();
      if($chkgd2) {
        $ImageOut = ImageCreateTrueColor($WidthOutCanv, $HeightOutCanv);
        imageAlphaBlending($ImageOut, false);
        imageSaveAlpha($ImageOut, true);
        if($doBack){
          $ColorCanvas=imagecolorallocate($ImageOut,$Rbg,$Gbg,$Bbg);
          imagefill($ImageOut,0,0, $ColorCanvas);
        }
      } else {
        $thumbnailImage = ImageCreate($WidthOutCanv, $HeightOutCanv);
      }
      switch($PicExIn['phpid']) {
      case IMG_GIF: $ImageIn = ImageCreateFromGIF($fileInFull); break;
      case IMG_JPG: $ImageIn = ImageCreateFromJPEG($fileInFull); break;
      case IMG_PNG: $ImageIn = ImageCreateFromPNG($fileInFull); break;
      case IMG_WBMP:$ImageIn = ImageCreateFromWBMP($fileInFull); break;
      case IMG_XPM: $ImageIn = ImageCreateFromXPM($fileInFull); break;
      }
      if($chkgd2) {
        ImageCopyResampled($ImageOut,$ImageIn,$lOutPic,$tOutPic,0,0,$WidthOutPic,$HeightOutPic,ImageSX($ImageIn),ImageSY($ImageIn));
      } else {
        ImageCopyResized($ImageOut,$ImageIn,$lOutPic,$tOutPic,0,0,$WidthOutPic,$HeightOutPic,ImageSX($ImageIn),ImageSY($ImageIn));
      }
      ImageDestroy($ImageIn);
      if(is_file($fileOutFull)){unlink($fileOutFull);}
      $done=false;
      switch($PicExIn['phpid']) {
      case IMG_GIF: $done=imagegif($ImageOut,$fileOutFull); break;
      case IMG_JPG: $done=imagejpeg($ImageOut,$fileOutFull); break;
      case IMG_PNG: $done=imagepng($ImageOut,$fileOutFull); break;
      case IMG_WBMP:$done=imagewbmp($ImageOut,$fileOutFull); break;
      case IMG_XPM: $done=imagexbm($ImageOut,$fileOutFull); break;
      }
      ImageDestroy($ImageOut);
      if($done){
        KDetfiles::setFilePermissions($fileOutFull,0644);
        $aResult['InfoOutEx']=$this->getFileInfoEx($fileOutFull);
        $aResult['lstErrs'][1]='Ended without Eror';
      }
      return  $aResult;
    }
    function makeThumbnail($fileNameFullorg, $DirNametmb,$fileNametmb, $maxWidth=50, $maxHeight=50, $replaceFile=FALSE) {
      $athumbInfo=array();
      $image = $fileNameFullorg;
      $imageInfo = getimagesize($image);
      $supported = FALSE;
      clearstatcache();
      $imagetypes=imagetypes();
      switch($imageInfo[2]) {
      case 1:                // we're converting GIF to JPG
      case 2:
      case 3:
        if(imagetypes() & IMG_PNG){$supported = TRUE;}
        $thmime='image/png';
      break;
      }
      if ($supported) {
        $currentWidth = $imageInfo[0];
        $currentHeight = $imageInfo[1];
        $finalScale=1;
        if(($currentWidth > $maxWidth) or ($currentHeight > $maxHeight)) {
          $widthScale  = $maxWidth / $currentWidth;
          $heightScale = $maxHeight / $currentHeight;
          if($widthScale < $heightScale){
            $finalScale = $widthScale;
          }else{
            $finalScale = $heightScale;
          }
        }
        $thumbnailWidth = round($finalScale * $currentWidth);
        $thumbnailHeight = round($finalScale * $currentHeight);
        if($thumbnailWidth<5){$thumbnailWidth=5;}
        if($thumbnailHeight<5){$thumbnailHeight=5;}
        if($thumbnailWidth>$maxWidth){$thumbnailWidth=$maxWidth;}
        if($thumbnailHeight>$maxHeight){$thumbnailHeight=$maxHeight;}
        $tlX= round(($maxWidth-$thumbnailWidth)/2);
        $tlY= round(($maxHeight-$thumbnailHeight)/2);
        $thumbnailImage = NULL;
        $chkgd2= KDetfiles::chkgd2();
        if($chkgd2) {
          $thumbnailImage = ImageCreateTrueColor($maxWidth, $maxHeight);
          imageAlphaBlending($thumbnailImage, false);
          imageSaveAlpha($thumbnailImage, true);
        } else {
          $thumbnailImage = ImageCreate($thumbnailWidth, $thumbnailHeight);
        }
        switch($imageInfo[2]) {
        case 1: $fullImage = ImageCreateFromGIF($image); break;
        case 2: $fullImage = ImageCreateFromJPEG($image); break;
        case 3: $fullImage = ImageCreateFromPNG($image); break;
        }
        if($chkgd2) {
          ImageCopyResampled($thumbnailImage, $fullImage, $tlX, $tlY,0, 0, $thumbnailWidth, $thumbnailHeight, ImageSX($fullImage), ImageSY($fullImage));
        } else {
          ImageCopyResized($thumbnailImage, $fullImage, $tlX, $tlY, 0, 0, $thumbnailWidth, $thumbnailHeight, ImageSX($fullImage), ImageSY($fullImage));
        }
        ImageDestroy($fullImage);
        if($replaceFile) { unlink($image); }
        if(is_file($DirNametmb .'/'. $fileNametmb)){
          unlink($DirNametmb .'/'. $fileNametmb);
        }
        $aNametmbnew = explode('.', $fileNametmb);
        switch($imageInfo[2]) {
        case 1:
        case 2:
        case 3:
          $fileaNametmbnew = $aNametmbnew[0] . ".png";
          imagepng($thumbnailImage, $DirNametmb .'/'. $fileaNametmbnew);
        break;
        }
        KDetfiles::setFilePermissions($DirNametmb .'/'. $fileaNametmbnew,0644);
        $athumbInfo['thumbdir']= $DirNametmb;
        $athumbInfo['filenameth']= $fileaNametmbnew;
        $athumbInfo['filetypetm']= $thmime;
        $athumbInfo['picwidthtm']= $thumbnailWidth;
        $athumbInfo['picheighttm']= $thumbnailHeight;
      }
      return  $athumbInfo;
    }

    function chkgd2(){
      if(function_exists("gd_info")) {
        $gdver = gd_info();
        if(strstr($gdver["GD Version"], "1.") != FALSE) { return FALSE;
        } else { return TRUE; }
      } else {
        ob_start();
        phpinfo(8);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $phpinfo=strip_tags($phpinfo);
        $phpinfo=stristr($phpinfo,"gd version");
        $phpinfo=stristr($phpinfo,"version");
        $end=strpos($phpinfo," ");
        $phpinfo=substr($phpinfo,0,$end);
        $phpinfo=substr($phpinfo,7);
        if(version_compare("2.0", $phpinfo)==1){
          return FALSE;
        }else{
          return TRUE;
        }
      }
    }// END FUNC chkgd2()
    function TagSplitStr($aTagBrakes,$strHTM){
      $TagSplitStr['before']='';
      $TagSplitStr['inner']='';
      $TagSplitStr['after']='';
      $TagSplitStr['did']='';
      if(strlen($strHTM)==0){return $Check_hrefs;}
      $pos_srt=strpos($strHTM,$aTagBrakes['Open']);
      if($pos_srt===false){
        $TagSplitStr['before']=$strHTM;
	      $TagSplitStr['inner']='';
	      $TagSplitStr['after']='';
        $TagSplitStr['did']='non';
        return $TagSplitStr;
      }
      if($pos_srt===0){
	      $TagSplitStr['before']='';
        $teil=substr($strHTM,strlen($aTagBrakes['Open']));
      }else{
        $TagSplitStr['before']=substr($strHTM,0,$pos_srt);
        $teil=substr($strHTM,$pos_srt+strlen($aTagBrakes['Open']));
      }
      $pos_end=strpos($teil,$aTagBrakes['Close']);
      if($pos_end===false){
        $TagSplitStr['inner']=$teil;
        $TagSplitStr['after']='';
	      $TagSplitStr['did']='open';
      }elseif($pos_end===0){
        $TagSplitStr['inner']='';
        $TagSplitStr['after']=substr($teil,strlen($aTagBrakes['Close']));
        $TagSplitStr['did']='empty';
      }else{
        $TagSplitStr['inner']=substr($teil,0,$pos_end);
        $TagSplitStr['after']=substr($teil,$pos_end+strlen($aTagBrakes['Close']));
        $TagSplitStr['did']='did';
      }
      return $TagSplitStr;
    }
    function suppress_whites($strText) {
      $suppress=$strText;
      $qty=0;
      $suppress=str_replace(chr(10),' ', $strText);
      $double_pos=strpos($suppress,'  ');
      while($double_pos !==false){
        $qty=$qty+1;
        if($qty>1000){break;}
	      $suppress=str_replace('  ',' ', $suppress);
	      $double_pos=strpos($suppress,'  ');
      }
      return $suppress;
    }
    function rteSafe($strText) {
      $tmpString = $strText;
      $tmpString = str_replace(chr(145), chr(39), $tmpString);
      $tmpString = str_replace(chr(146), chr(39), $tmpString);
      $tmpString = str_replace(chr(147), chr(34), $tmpString);
      $tmpString = str_replace(chr(148), chr(34), $tmpString);
      $tmpString = str_replace("'", "&#39;", $tmpString);
      $tmpString = str_replace(chr(10), " ", $tmpString);
      $tmpString = str_replace(chr(13), " ", $tmpString);
      return $tmpString;
    }
    function nameToSafe($name) {
      $maxlen=250;
      $noalpha = '@';
      $alpha   = 'AEIOUYaeiouyAEIOUaeiouAEIOUaeiouAEIOUaeiouyAaOoAaNnCcaooa';
      $name = substr($name, 0, $maxlen);
      $name = strtr($name, $noalpha, $alpha);
      return preg_replace('/[^a-zA-Z0-9._]/', '_', $name);
    }
    function size2str($size) {
      if($size >= 1073741824) {
        $size = round($size / 1073741824 * 100) / 100 . " GB";
      } elseif($size >= 1048576) {
        $size = round($size / 1048576 * 100) / 100 . " MB";
      } elseif($size >= 1024) {
        $size = round($size / 1024 * 100) / 100 . " KB";
      } else $size = $size . " Bytes";
      if($size==0) $size="-";
      return $size;
    }
    function Rand_Str($Kind,$length){
      $Radix[1] ='123456789^'.'abdefghimn'.'qrty*ABDEF'.'GHJLMNQRTY';
      $Radix[2] ='123456789'.'abdefghimn'.'qrtyABDEF'.'GHJLMNQRTY';
      $Radix[3] ='abdefghimn'.'qrtyABDEFG'.'HJLMNQRTY';
      $Radix[4] ='ABCDEFGHIJ'.'KLMNQRSTUV'.'WXYZ';
      $Radix[5] ='1234567890';
      $Cnt[1]=39;
      $Cnt[2]=37;
      $Cnt[3]=28;
      $Cnt[4]=33;
      $Cnt[5]=9;
      $strrand='';
      if($length>0){
        for($i=1; $i<=$length; $i++){
          mt_srand((double)microtime()*1000000);
          $irand = mt_rand(0,$Cnt[$Kind]);
          $strrand .= substr($Radix[$Kind],$irand,1);
        }
      }
      return $strrand;
    }
    function CenterShrink($maxWidth,$maxHeight,$currentWidth,$currentHeight){
      $positSet=array();
      $positSet['width']=0;
      $positSet['height']=0;
      $positSet['tlX']=0;
      $positSet['tlY']=0;
      $thumbnailWidth = $currentWidth;
      $thumbnailHeight = $currentHeight;
      if(($currentWidth <1) or ($currentHeight <1)) {
        $thumbnailWidth = $maxWidth;
        $thumbnailHeight = $maxHeight;
      }elseif(($currentWidth < $maxWidth) and ($currentHeight < $maxHeight)
      or ($currentWidth > $maxWidth) or ($currentHeight > $maxHeight)) {
        $widthScale  = $maxWidth / $currentWidth;
        $heightScale = $maxHeight / $currentHeight;
        if($widthScale < $heightScale){
          $finalScale = $widthScale;
        }else{
          $finalScale = $heightScale;
        }
        $thumbnailWidth = round($finalScale * $currentWidth);
        $thumbnailHeight = round($finalScale * $currentHeight);
      }
      if($thumbnailWidth<5){$thumbnailWidth=5;}
      if($thumbnailHeight<5){$thumbnailHeight=5;}
      if($thumbnailWidth>$maxWidth){$thumbnailWidth=$maxWidth;}
      if($thumbnailHeight>$maxHeight){$thumbnailHeight=$maxHeight;}
      $positSet['width']=$thumbnailWidth;
      $positSet['height']=$thumbnailHeight;
      $positSet['tlX']= round(($maxWidth-$thumbnailWidth)/2);
      $positSet['tlY']= round(($maxHeight-$thumbnailHeight)/2);
      return $positSet;
    }
    function lstTree($lstCatall) {
      global $GKDVars;
      $lstCatndx=array();
      $lstCatndx['0']['ctgry']=array();
      $lstCatndx['0']['ctgry']["cat_name"]='Tree';
      $lstCatndx['0']['ctgry']["name"]='Root';
      $lstCatndx['0']['ctgry']["sub_counter"]=0;
      $lstCatndx['0']['ctgry']["counter"]=0;
      $lstCatndx['0']['path']=array();
      $lstCatndx['0']['subs']=array();
      $lstSubs=array();
      $aPass=array();
      $aParents=array();
      $aParentsErr =array();
      $parent_id=0;
      if(count($lstCatall)>0){
        foreach($lstCatall as $cat_id=>$row){
          if($row['parent_id']==0){continue;}
          if(!isset($lstCatall[$row['parent_id']])){
            $aParentsErr[$cat_id]=0;
            $lstCatall[$cat_id]['parent_id']=0;
          }
        }
      }
      if(isset($lstCatall[$parent_id])){
        $row= $lstCatall[$parent_id];
        $lstCatndx[$parent_id]['ctgry']=$row;
        unset($lstCatall[$parent_id]);
      }elseif($parent_id>0){
        $lstCatndx[$parent_id]['ctgry']=array();
      }
      $lstCatndx[$parent_id]['path']=array();
      $lstCatndx[$parent_id]['subs']=array();
      unset($lstSubs);
      unset($aPass);
      $aPass[$parent_id]=1;
      $lstSubs=array();
      $domore=1;
      while($domore>0){
        if(count($lstCatall)<1){
          $domore=0;
        }else{
          unset($aPass);
          $aPass=$lstCatndx[$parent_id]['path'];
          $aPass[$parent_id]=1;
          foreach($lstCatall as $cat_id=>$row){
            if($row['parent_id']==$parent_id){
              $lstCatndx[$parent_id]['subs'][$cat_id]=1;
              $lstCatndx[$cat_id]['ctgry']=$row;
              $lstCatndx[$cat_id]['path']=$aPass;
              $lstCatndx[$cat_id]['subs']=array();
              unset($lstCatall[$cat_id]);
            }
          }
          $aParents[$parent_id]=1;
          $parent_id=0;
          if(count($lstCatall)>0){
            foreach($lstCatndx as $cat_id=>$row){
              if(!isset($aParents[$cat_id])){
                $parent_id=$cat_id;
                break;
              }
            }
          }
          if($parent_id<1){$domore=0;}
        }
      }
      if(count($lstCatall)>0){
        unset($aPass);
        $aPass['0']=1;
        foreach($lstCatall as $cat_id=>$row){
          $lstCatndx['0']['subs'][$cat_id]=1;
          $lstCatndx[$cat_id]['ctgry']=$row;
          $lstCatndx[$cat_id]['ctgry']['parent_id']=0;
          $lstCatndx[$cat_id]['path']=$aPass;
          $lstCatndx[$cat_id]['subs']=array();
          $aParentsErr[$cat_id]=0;
        }
      }
      if(isset($acrrTblinf['dofix']) and $acrrTblinf['dofix']>0 and count($aParentsErr)>0){
        foreach($aParentsErr as $cat_id=>$val){
        unset($aConds);
        unset($aFldVals);
        unset($rslt);
          $aConds[$acrrTblinf['cat_idfld']]=$cat_id;
          $aFldVals[$acrrTblinf['parentfld']]= $val;
          $rslt=$this->KDcarib->mdb->UpdRcd($acrrTblinf['table'],$aConds,$aFldVals);
        }
      }
      return $lstCatndx;
    }
    function calc_CatBrnch($lstCatndx,$crrcat_id) {
      $aResult=array();
      $aResult['tree']=array();
      $aResult['pool']=array();
      $aResult['ordndx']=array();
      $lstTree=array();
      $lstChldrTree=array();
      $lstOrdNdx=array();
      $aCat=array();
      $subs=array();
      $lstPool=$lstCatndx;
      if(isset($lstPool[$crrcat_id])){
        $aCat=$lstPool[$crrcat_id];
        unset($lstPool[$crrcat_id]);
        $subs=$aCat['subs'];
        unset($aCat['subs']);
        $aCat['subs']=array();
        $lstOrdNdx[$crrcat_id]=1;
        if(count($subs)>0){
          foreach($subs as $cat_id=>$dum){
            if(isset($lstPool[$cat_id])){
              $lstOrdNdx[$cat_id]=1;
              unset($lstChldrTree);
              $lstChldrTree=$this->calc_CatBrnch($lstPool,$cat_id);
              $aCat['subs'][$cat_id]=$lstChldrTree['tree'];
              if(count($lstChldrTree['ordndx'])>0){
                foreach($lstChldrTree['ordndx'] as $cat_idndx=>$dum){
                  $lstOrdNdx[$cat_idndx]=1;
                }
              }
              unset($lstPool);
              $lstPool=$lstChldrTree['pool'];
            }
          }
        }
        $lstTree=$aCat;
      }
      $aResult['tree']=$lstTree;
      $aResult['pool']=$lstPool;
      $aResult['ordndx']=$lstOrdNdx;
      return $aResult;
    }
    function srct_Bread($lstCatndx,$crrcat_id) {
      $aResult=array();
      $aResult['bread']='';
      $aResult['breadpar']='';
      $aResult['lstBreadprnt']=array();;
      $breadpar='';
      $bread='';
      $aCatPar=array();
      $aCatBrd=array();
      $lstBreadprnt=array();
      if(isset($lstCatndx[$crrcat_id])){
        unset($lstBreadprnt);
        $lstBreadprnt=array();
        $aCat=$lstCatndx[$crrcat_id];
        $lstBreadprnt=$aCat['path'];
        $indx=0;
        foreach($lstBreadprnt as $cat_id=>$val){
          if( $cat_id<1){continue;}
          unset($aCatBrd);
          $indx=$indx+1;
          if($indx>1){$breadpar .= '/';}
          $breadpar .=$lstCatndx[$cat_id]['ctgry']['name'];
          $aCatBrd=$lstCatndx[$cat_id];
          $lstBreadprnt[$cat_id]=count($aCatBrd['path']);
        }
        if($indx>0){$bread =$breadpar . '/';}
        $bread .=  $aCat['ctgry']['name'];
        unset($lstBreadprnt[0]);
      }
      $aResult['bread']=$bread;
      $aResult['breadpar']=$breadpar;
      $aResult['lstBreadprnt']= $lstBreadprnt;
      return $aResult;
    }
    function srct_SplitTree($lstCatndx,$catiddef,$crrcat_id) {
      $aResult=array();
      $aResult['current']=0;
      $aResult['parentid']=0;
      $aResult['bread']=array();
      $aResult['sybls']=array();
      $aResult['chldr']=array();
      $aCat=array();
      if($crrcat_id>0 and isset($lstCatndx[$crrcat_id])){$aResult['current']=$crrcat_id;}
      if($aResult['current']<1 and isset($lstCatndx[$catiddef])){$aResult['current']=$catiddef;}
      if(count($lstCatndx)<1){return $aResult;}
      if($aResult['current']<1){
        foreach($lstCatndx as $cat_id=>$row){
          if($cat_id<1){continue;}
          if($row['ctgry']['parent_id']==0){
            $aResult['current']= $cat_id;
            break;
          }
        }
      }
      $aCat= $lstCatndx[$aResult['current']];
      $aResult['parentid']=$aCat['ctgry']['parent_id'];
      $srct_Bread= $this->srct_Bread($lstCatndx,$aResult['current']);
      $aResult['bread']=$srct_Bread['lstBreadprnt'];
      $level=count($aCat['path']);
      foreach($lstCatndx as $cat_id=>$val){
        if($cat_id<1){continue;}
        if($lstCatndx[$cat_id]['ctgry']['parent_id']==$aCat['ctgry']['parent_id']){
          $aResult['sybls'][$cat_id]=$level;
        }
      }
      if(count($aCat['subs'])>0){
        foreach($aCat['subs'] as $cat_id=>$val){
          $aResult['chldr'][$cat_id]=$level+1;
        }
      }
      return $aResult;
    }
    function xmlTree(&$string) {
      $aResult=array();
      $aResult['tree']=array();
      $aResult['lstErrs']=array();
      $xmTag=array();
      $axmTagCont=array();
      $rowchld=array();
      $parser = xml_parser_create();
      xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
      $did=xml_parse_into_struct($parser, $string, $vals, $index);
      if($did===0){
        $aResult['lstErrs'][1]='XML error: xml_parse_into_struct';
        $aResult['src']=htmlentities($string);
        return $aResult;
      }
      xml_parser_free($parser);
      $tgqty=count($vals);
      $aResult['tree']=$this->xmlBranch($tgqty,$vals,$index);
      return $aResult;
    }
    function xmlBranch($tgqty,$atagset, $index) {
      $xmTagList=array();
      $xmTagListChld=array();
      $aTagListChld=array();
      $xmTag=array();
      $xmTagChld=array();
      $ndx=0;
      $iqty=count($atagset);
      for($i=0;$i<$tgqty;$i++){
        if(!isset($atagset[$i])){continue;}
        $doskip=0;
        $row=$atagset[$i];
        unset($xmTag);
        $xmTag=array();
        $xmTag['tag']=$row['tag'];
        $xmTag['aindx']=$i;
        $xmTag['attributes']=array();
        if(isset($row['attributes'])){
          $xmTag['attributes']=$row['attributes'];
        }
        switch($row['type']){
        case 'complete':
          $xmTag['value']=$row['value'];
        break;
        case 'close':
          $doskip=1;
        break;
        case 'open':
        case 'cdata':
          unset($xmTagListChld);
          unset($aTagListChld);
          $xmTagListChld=array();
          $ndxClose=-1;
          foreach($index[$row['tag']] as $j=>$pos){
            if(!isset($atagset[$pos])){continue;}
            unset($aTagChld);
            if($pos>$i and $ndxClose<0){
              $aTagChld=$atagset[$pos];
              if($aTagChld['level']==$row['level']){
                $ndxClose=$pos;
                break;
              }
            }
          }
          if($ndxClose<0){$ndxClose=$tgqty+1;}
          $ndxchld=0;
          for($icnt=$i+1;$icnt<$ndxClose;$icnt++){
            $ndxchld=$ndxchld+1;
            $aTagListChld[$icnt]=$atagset[$icnt];
          }
          $xmTagListChld=$this->xmlBranch($tgqty,$aTagListChld,$index);
          $xmTag['branch']=$xmTagListChld;
          $i=$ndxClose-1;
        break;
        }
        $ndx=$ndx+1;
        if($doskip<1){
          $ndx=$ndx+1;
          $xmTagList[]=$xmTag;
        }
      }
      return $xmTagList;
    }
    function soctDiaLog($servr,$target,$areqpars){
      $aResult=array();
      $aResult['data']='';
      $aResult['header']='';
      $aResult['lstErrs']=array();
      $strh0='';
      $data='';
      $fp = fsockopen ($servr, 80, $errno, $errstr, 30);
      if(!$fp){
        $aResult['lstErrs'][1]='fsoc_errno=' .$errno;
        $aResult['lstErrs'][1] .='; fsoc_errstr: ' .$errstr;
      }else{
        if(count($areqpars)>0){
          $indx=0;
          foreach($areqpars as $par=>$val){
            $indx=$indx+1;
            if($indx>1){$data=$data .'&';}
            $data=$data . $par .'=' . $val;
          }
        }
        $query = "POST ". $target ." HTTP/1.0\r\n";
        $query .="User-Agent: PHPRPC Client v 0.2.7 (c) Gregory A. Rozanoff, 2005\r\n";
        $query .="Host: " .$servr ."\r\n";
        $query .="Connection: close\r\n";
        $query .="Content-Type: application/x-www-form-urlencoded\r\n";
        $query .="Content-Length: ".strlen($data)."\r\n\r\n".$data;
        $tmp='';
        if (fputs($fp, $query, strlen($query))){
          while(!feof($fp)){
            $tmp .= fread($fp, 4096);
          }
        }else{
          $aResult['lstErrs'][1] ='Error: fputs ';
        }
        fclose ($fp);
        $poshdr=strpos($tmp,"\r\n\r\n");
        $reshead=trim(substr($tmp, 0, $poshdr));
        if(trim($reshead)!=''){
          $aResult['header']=$reshead;
          $aheadr = preg_split("/(\r?\n)/s", $aResult['header']);
          if(isset($aheadr[0]) and trim($aheadr[0]) !=''){
            $strh0=$aheadr[0];
          }
        }
        $possucc=strpos($strh0,'200');
        if($possucc>0){
          $pos=strpos($tmp,"\r\n\r\n")+strlen("\r\n\r\n");
          $resdat=trim(substr($tmp, $pos));
          if(trim($resdat)!=''){
            $aResult['data']=$resdat;
          }
        }else{
          $aResult['lstErrs'][1] ='Connection error: ' . $strh0;
        }
      }
      return $aResult;
    }
    function LIP2SIP($LIP) {
      $aResult=array();
      $aResult['aSIP']=array();
      $aResult['aSIP'][0]=0;
      $aResult['aSIP'][1]=0;
      $aResult['aSIP'][2]=0;
      $aResult['aSIP'][3]=0;
      $aResult['SIP']='';
      $aResult['LIP']=$LIP;
      $i=0;
      $aResult['aSIP'][0]=floor($LIP/pow(256,3));
      $aResult['aSIP'][1]=floor(($LIP-$aResult['aSIP'][0]*pow(256,3))/pow(256,2));
      $aResult['aSIP'][2]=floor(($LIP-$aResult['aSIP'][0]*pow(256,3)-$aResult['aSIP'][1]*pow(256,2))/256);
      $aResult['aSIP'][3]=$LIP-$aResult['aSIP'][0]*pow(256,3)-$aResult['aSIP'][1]*pow(256,2)-$aResult['aSIP'][2]*256;
      for($i=0;$i<4;$i++){
        if($i>0){$aResult['SIP']=$aResult['SIP'] . '.';}
        if($aResult['aSIP'][$i]>0){
          $aResult['SIP']=$aResult['SIP'] . $aResult['aSIP'][$i];
        }else{
          $aResult['SIP']=$aResult['SIP'] . '0';
        }
      }
      return $aResult;
    }
    function SIP2LIP($strSIP) {
      $aResult=array();
      $aResult['aSIP']=array();
      $aResult['aSIP'][0]=0;
      $aResult['aSIP'][1]=0;
      $aResult['aSIP'][2]=0;
      $aResult['aSIP'][3]=0;
      $aResult['SIP']=$strSIP;
      $aResult['LIP']=0;
      $aResult['aSIP']=explode('.',trim($strSIP));
      $aResult['LIP']=$aResult['aSIP'][0]*pow(256,3)+$aResult['aSIP'][1]*pow(256,2)+$aResult['aSIP'][2]*pow(256,1)+$aResult['aSIP'][3]*pow(256,0);
      return $aResult;
    }
    function IPmap($strSIP,$CIDR) {
      $aResult=array();
      $aResult['CIDR']=$CIDR;
      $aResult['net']=array();
      $aResult['mask']=array();
      $aResult['brcast']=array();
      $aResult['ip']=array();
      $SIP2LIP=array();
      $imask=0;
      $inet=0;
      $ibrcast=0;
      $powrange=32-$CIDR;
      $aResult['ip']=$this->SIP2LIP($strSIP);
      $imask=pow(2,32)-pow(2,$powrange);
      $inet=floor($aResult['ip']['LIP']/pow(2,$powrange))*pow(2,$powrange);
      $ibrcast=$inet+pow(2,$powrange)-1;
      $aResult['mask']=$this->LIP2SIP($imask);
      $aResult['net']=$this->LIP2SIP($inet);
      $aResult['brcast']=$this->LIP2SIP($ibrcast);
      return $aResult;
    }
    function hostInfo($sitesfileGlbl) {
      $glbInfo=array();
      $glbInfo['SiteList']=array();
      $glbInfo['farms']=array();
      if(file_exists($sitesfileGlbl)){
        $strConf= $this->read_File($sitesfileGlbl);
        $lstPrfiles= $this->UnSerSafe($strConf);
        if(isset($lstPrfiles['SiteList']) and(count($lstPrfiles['SiteList'])>0)){
          foreach($lstPrfiles['SiteList'] as $stid=>$aprfl){
            $glbInfo['SiteList'][$stid]=$aprfl;
            $glbInfo['farms'][$aprfl['farm']]['sites'][$stid]=$aprfl['sitegrp'];
            if(!isset($glbInfo['farms'][$aprfl['farm']]['dir'])){$glbInfo['farms'][$aprfl['farm']]['dir']=$stid;}
          }
        }
      }
      return $glbInfo;
    }
    function id_browser() {
      $browser=$_SERVER['HTTP_USER_AGENT'];
      if(ereg('Opera(/| )([0-9].[0-9]{1,2})', $browser)) {
        return 'OPERA';
      } else if(ereg('MSIE ([0-9].[0-9]{1,2})', $browser)) {
        return 'IE';
      } else if(ereg('OmniWeb/([0-9].[0-9]{1,2})', $browser)) {
        return 'OMNIWEB';
      } else if(ereg('(Konqueror/)(.*)', $browser)) {
        return 'KONQUEROR';
      } else if(ereg('Mozilla/([0-9].[0-9]{1,2})', $browser)) {
        return 'MOZILLA';
      } else {
        return 'OTHER';
      }
    }
    function flash_file($fileInFull,$fileOutName,$FileInfoInEx){
      @ob_end_clean();
      if(ini_get('zlib.output_compression')){ini_set('zlib.output_compression', 'Off');}
      header('Content-Type: ' . $FileInfoInEx['mimeExt']['type']);
      header('Content-Disposition: attachment; filename="'. $fileOutName . '"');
      header('Content-Transfer-Encoding: binary');
      header('Accept-Ranges: bytes');
      header('Cache-control: private');
      header('Pragma: private');
      header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
      header("Content-Length: ".$FileInfoInEx['filesize']);
      readfile($fileInFull);
      @ob_start(false); // prevent unwanted output
      exit;
    }
    function pathinfo_ex($fileInFull){
      $pathinfo_ex=array();
      $pathinfo=pathinfo($fileInFull);
      $dirname='';
      $basename=$fileInFull;
      $filename=$fileInFull;
      $extension='';
      if(isset($pathinfo['dirname'])){$dirname=$pathinfo['dirname'];}
      if($dirname=='.'){$dirname='';}
      if(isset($pathinfo['basename'])){
        $basename=$pathinfo['basename'];
        $filename=$pathinfo['basename'];
        if(isset($pathinfo['extension'])){$extension=$pathinfo['extension'];}
        if($extension !=''){
          $filename=str_replace('.' . $extension, "", $filename);
        }
      }
      $pathinfo_ex['dirname']=$dirname;
      $pathinfo_ex['basename']=$basename;
      $pathinfo_ex['extension']=$extension;
      $pathinfo_ex['filename']=$filename;
      return $pathinfo_ex;
    }
    function getNavMap($strcMenus,$actp){
      global $GKDVars;
      $NavMap=array();
      $NavTree=array();
      $NavIndx=$this->getNavIndz($strcMenus);
      $NavTree=$this->getNavTree($NavIndx,$actp);
      $NavMap=$NavTree;
      $NavMap['menattrs']=$NavIndx['menattrs'];
      $NavMap['tops']=$NavIndx['tops'];
      $NavMap['slaves']=$NavIndx['slaves'];
      return $NavMap;
    }
    function getNavIndz($strcMenus){
      global $GKDVars;
      $NavIndx=array();
      $NavIndx['menattrs']=array();
      $NavIndx['tops']=array();
      $NavIndx['slaves']=array();
      $lstmns=array();
      $menattrs=array();
      $menblks=array();
      $mnlst='';
      $prfx='';
      $reqalas='';
      $prntals='';
      for($i=1;$i<3;$i++){
        switch ($i){
        case 1:$mnlst='mnHlst';break;
        case 2:$mnlst='mnVlst';break;
        }
        if(!isset($strcMenus[$mnlst])){continue;}
        $lstmns=$strcMenus[$mnlst];
        if(count($strcMenus[$mnlst])<1){continue;}
        foreach($strcMenus[$mnlst] as $mals=>$lstmns){
          if(!isset($lstmns['menblks'])){continue;}
          $NavIndx['menattrs'][$mals]=$lstmns['menattrs'];
          if($NavIndx['menattrs'][$mals]['menlvl']=='slave'){
            foreach($lstmns['menblks'] as $prnt=>$prntset){
              if(isset($lstmns['menblks'][$prnt]['itmset'])){
                foreach($lstmns['menblks'][$prnt]['itmset'] as $ital=>$mitem){
                  $mitem['mnlst']=$mnlst;
                  $mitem['actp']=$prnt;
                  $mitem['mals']=$mals;
                  $mitem['subs']=array();
                  $NavIndx['slaves'][$ital]=$mitem;
                }
              }
            }
          }else{
            foreach($lstmns['menblks'] as $actp=>$aptpset){
              if(!isset($lstmns['menblks'][$actp]['itmset'])){continue;}
              if(count($lstmns['menblks'][$actp]['itmset'])<1){continue;}
              foreach($lstmns['menblks'][$actp]['itmset'] as $ital=>$mitem){
                $mitem['mnlst']=$mnlst;
                $mitem['actp']=$actp;
                $mitem['mals']=$mals;
                $mitem['subs']=array();
                $NavIndx['tops'][$ital]=$mitem;
              }
            }
          }
        }
      }
      return $NavIndx;
    }
    function getNavTree($NavIndx,$actp){
      global $GKDVars;
      $NavTree['nav']=array();
      $NavTree['pages']=array();
      $NavSubSubs=array();
      foreach($NavIndx['tops'] as $ital=>$mitem){
        switch($actp){
        case 'pbz': if(($mitem['actp']!='pbz')or($mitem['actp']!='sngl')){continue;}break;
        default: if($mitem['actp'] !=$actp){continue;}
        }
        if(!isset($GKDVars->aPageTree[$mitem['mitmpag']])){continue;}
        unset($NavSubSubs);
        $mitem['level']=1;
        $NavSubSubs=$this->getSubTree($NavIndx['slaves'],$ital,2);
        $mitem['subs']=$NavSubSubs['nav'];
        $NavTree['nav'][$ital]=$mitem;
        $NavTree['pages'][$mitem['mitmpag']]['pv']=$ital;
        $NavTree['pages'][$mitem['mitmpag']]['level']=1;
        foreach($NavSubSubs['pages'] as $pals=>$pahref){
          $NavTree['pages'][$pals]=$pahref;
          $NavTree['pages'][$pals]['pv']=$ital;
        }
      }
      return $NavTree;
    }
    function getSubTree($NavSlaves,$italTop,$lavel){
      $NavSubs['nav']=array();
      $NavSubs['pages']=array();
      $NavSubSubs=array();
      $navFldName='';
      switch($lavel){
      case 1:$navFldName='pv';break;
      case 2:$navFldName='ps';break;
      case 3:$navFldName='pc';break;
      }
      foreach($NavSlaves as $ital=>$mitem){
        if($mitem['actp'] !=$italTop){continue;}
        unset($NavSubSubs);
        $mitem['level']=$lavel;
        $NavSubSubs=$this->getSubTree($NavSlaves,$ital,$lavel+1);
        $mitem['subs']=$NavSubSubs['nav'];
        $NavSubs['nav'][$ital]=$mitem;
        $NavSubs['pages'][$mitem['mitmpag']][$navFldName]=$ital;
        $NavSubs['pages'][$mitem['mitmpag']]['level']=$lavel;
        foreach($NavSubSubs['pages'] as $pals=>$pahref){
          $NavSubs['pages'][$pals]=$pahref;
          $NavSubs['pages'][$pals][$navFldName]=$ital;
        }
      }
      return $NavSubs;
    }

  }
?>